/* This is header file for Rucker's randomize functions.  These
randomizing functions are based on a cellular automata rule discovered
by Stephen Wolfram and called Rule 30. */

extern void rrSeed(unsigned int); //Start the randomizer off in a specific state
extern unsigned int rrRandomize(void); //Seed with the time in seconds
extern unsigned int rrRandom(unsigned int n); //Return an int betweeon 0 and n - 1
extern unsigned char rrRandombyte(void); //Return a byte between 0 and 255
extern unsigned short rrRandomshort(unsigned short n); // Short between 0 and n-1
extern unsigned long rrRandomlong(unsigned long n); //Long between 0 and n-1
extern double rrRandomreal(void); //A real between 0.0 and 1.0
extern double rrRandomsignreal(void); //A real between -1.0 and 1.0
extern double rrRandomreal(double lo, double hi); //A real between lo and hi
extern double rrRandomsign(void); //1.0 or -1.0
extern void rrRandomunitdiskpair(double *x, double *y);
	// Makes (x,y) a random point with distance <= 1 from (0,0)
extern void rrRandomunitpair(double *x, double *y);
	// Makes (x,y) a random point with distance 1 from (0,0)

